/* ========================================
Obsługa czujnika DHT11 v. 0.4
(c)2021 Filip Sala, Marzena Sala-Tefelska
===========================================*/
#include <avr/io.h>
#include <util/delay.h>
#include "lcd_lib.h"
#define DHT11_PIN PA0
#define DHT11_PORT PORTA
#define DHT11_DDR DDRA
#define DHT11_PINPORT PINA
#define DHT11_LOW DHT11_DDR |= (1 << DHT11_PIN); DHT11_PORT &= ~(1 << DHT11_PIN);
#define DHT11_HIGH DHT11_DDR &= ~(1 << DHT11_PIN);
#define DHT11_STATE (DHT11_PINPORT & (1 << DHT11_PIN))

uint8_t DHT11_init(void)
{
 DHT11_LOW;
 _delay_ms(18); 
 DHT11_HIGH;
 _delay_us(40); 
 uint8_t result;
 //sprawdzamy czy urządzenie odpowiada
 if (DHT11_STATE) result = 0; else result = 1;
 _delay_us(90);	
 //czekamy na stan niski (L)
 //czyli na początek transmisji
 //o ile urządzenie odpowiada
 if (result) while (DHT11_STATE); 
 return result;
}

uint8_t DHT11_readbit(void)
{
 //odczyt rozpoczyna się od 50us stanu niskiego.
 while (!DHT11_STATE); //czekamy na stan wysoki (H)
 _delay_us(40); 
 uint8_t bit;
 //sprawdzenie stanu po 40us od pojawienia się stanu H
 if (DHT11_STATE) bit = 1; else bit = 0; 
 while (DHT11_STATE); //czekamy na stan niski (L)
 return bit;
}

uint8_t DHT11_readbyte(void)
{
 uint8_t byte = 0;
 for (int8_t i = 7; i >= 0 ; i--) 
 {
  byte |= (DHT11_readbit() << i);
 }
return byte;
}

int main(void)
{
 lcd_init();
 lcd_display_control(1,0,0);
 DHT11_DDR |= (1 << DHT11_PIN);
 DHT11_PORT |= (1 << DHT11_PIN);
 _delay_ms(2000);
 while (1)
 {
  if (DHT11_init())
  {
   uint8_t hum_h = DHT11_readbyte();
   uint8_t hum_l = DHT11_readbyte();
   uint8_t temp_h = DHT11_readbyte();
   uint8_t temp_l = DHT11_readbyte();
   lcd_gotoXY(0,0);
   lcd_text("Wilg=");
   lcd_integer(hum_h); //wilgotność
   lcd_text("% T=");
   lcd_integer(temp_h); //temperatura
   lcd_symbol(223); //symbol stopnia
   lcd_text("C   ");
   //Można sprawdzić, że bajty 
   //niskie hum_l oraz temp_l są zerowe 
   lcd_gotoXY(0,1);
   lcd_text("HL:");
   lcd_integer(hum_l);
   lcd_text(" TL:");
   lcd_integer(temp_l);
   _delay_ms(1000);
  } else
	{
	 lcd_clear();
	 lcd_text("Brak urzadzenia");
	 _delay_ms(2000);
	}
 }
return 0;
}